<?php

namespace Database\Seeders\UpdateSeeder;

use App\Models\Core\Auth\Role;
use App\Models\Core\Auth\Type;
use App\Models\Core\Notification\NotificationTemplate;
use App\Models\Core\Setting\NotificationAudience;
use App\Models\Core\Setting\NotificationChannel;
use App\Models\Core\Setting\NotificationEvent;
use App\Models\Core\Setting\NotificationSetting;
use Database\Seeders\Traits\DisableForeignKeys;
use Illuminate\Database\Seeder;
use Illuminate\Database\Eloquent\Builder;

class NotificationUpdateSeeder extends Seeder
{
    use DisableForeignKeys;

    public function run()
    {
        $this->disableForeignKeys();
        $appTypeId = Type::findByAlias('app')->id;

        $event = NotificationEvent::query()->create([
            'name' => 'new_invoice_generate',
            'type_id' => $appTypeId
        ]);

        $mail = new NotificationTemplate();
        $mail->subject = 'New Invoice generated {invoice_number}';
        $mail->default_content = '<p><img src="{app_logo}" style="height: 75px"></p>
            <p>
            </p>
            <p>
            <span style="background-color: var(--form-control-bg) ; color: var(--default-font-color) ;">Hello {receiver_name}</span><br>
            </p>
            <br>
            New Invoice generated {invoice_number}
            </p>
            <p></p><p>Thanks for being with us.
            </p><p>Regards,</p><p>{app_name}</p><p></p><p></p>';
        $mail->type = 'mail';
        $mail->save();
        $mail->custom_content = '<p><img src="{app_logo}" style="height: 75px"></p>
            <p>
            </p>
            <p>
            <span style="background-color: var(--form-control-bg) ; color: var(--default-font-color) ;">Hello {receiver_name}</span><br>
            </p>
            <br>
            New Invoice generated {invoice_number}
            </p>
            <p></p><p>Thanks for being with us.
            </p><p>Regards,</p><p>{app_name}</p><p></p><p></p>';
        $mail->type = 'mail';
        $mail->save();

        $event->templates()->attach(
            [$mail->id]
        );

        $database = new NotificationTemplate();
        $database->subject = 'New Invoice generated {invoice_number}';
        $database->default_content = 'New Invoice generated {invoice_number}';
        $database->custom_content = null;
        $database->type = 'database';
        $database->save();

        $event->templates()->attach(
            [$database->id]
        );

//      $paymentReceived = NotificationEvent::where('name','payment_recived')->first();
//      foreach ($paymentReceived->templates as $template){
//          $template->update([
//              'default_content' => `<p><img src="{app_logo}" style="height: 75px"></p>
//            <p>
//            </p><p><span style="background-color: var(--form-control-bg) ; color: var(--default-font-color) ;">Hello, {receiver_name}</span><br></p><p>
//            Hope this mail finds you well and healthy. We received your payment.
//            Please see attached invoice {invoice_number}.
//            <br>
//            </p>
//            <p></p><p>Thanks for being with us.
//            </p><p>Regards,</p><p>{app_name}</p><p></p><p></p>',
//              'custom_content' => '<p><img src="{app_logo}" style="height: 75px"></p>
//            <p>
//            </p><p><span style="background-color: var(--form-control-bg) ; color: var(--default-font-color) ;">Hello, {receiver_name}</span><br></p><p>
//            Hope this mail finds you well and healthy. We received your payment.
//            Please see attached invoice {invoice_number}.
//            <br>
//            </p>
//            <p></p><p>Thanks for being with us.
//            </p><p>Regards,</p><p>{app_name}</p><p></p><p></p>`,
//          ]);
//      }


        $channels = NotificationChannel::query()
            ->where('name', '=', 'database')
            ->get()
            ->pluck('name');

        $roles = Role::query()
            ->where('is_admin', 1)
            ->whereHas('type', function (Builder $query) {
                $query->where('alias', 'app');
            })->get()
            ->pluck('id');

        $app_type_id = Type::findByAlias('app')->id;

        NotificationEvent::where('type_id', $app_type_id)
            ->whereIn('name', ['new_invoice_generate'])
            ->get()->map(function ($event) use ($channels, $roles) {
            $notification_setting = NotificationSetting::query()->create([
                'notification_event_id' => $event->id,
                'notify_by' => $channels
            ]);

            $notification_setting->audiences()->saveMany([
                new NotificationAudience([
                    'audience_type' => 'roles',
                    'audiences' => $roles
                ])
            ]);
        });
        $this->enableForeignKeys();
    }

}
