<?php

namespace App\Services\App\SmsSetting;

use App\Models\Core\Setting\Setting;
use App\Repositories\Core\Setting\SettingRepository;

class TwilioService
{
    public function updateTwilioCredentials($request)
    {
        foreach ($request->only( 'sms_driver', 'account_sid', 'auth_token', 'twilio_number','test_number','send_auto_sms') as $key => $item) {

            $setting = resolve(SettingRepository::class)->createSettingInstance($key, 'sms_setting');

            $setting->name = $key;
            $setting->value = encrypt($item);
            $setting->context = 'sms_setting';

            $setting->save();

        }

        return $this;
    }

    public function getData()
    {
        $data = resolve(SettingRepository::class)
            ->formatSettings(
                Setting::query()->where('context', 'sms_setting')->get(), true
            );

        if (filled($data)) {
            return [
                'test_number' => $data['test_number'] ?? null,
                'sms_driver' => $data['sms_driver'] ?? null,
                'account_sid' => $data['account_sid'] ?? null,
                'auth_token' => $data['auth_token'] ?? null,
                'twilio_number' => $data['twilio_number'] ?? null,
                'send_auto_sms' => $data['send_auto_sms'] ?? false,
            ];
        } else return [];
    }
}