<?php


namespace App\Notifications\App\Invoice;


use App\Mail\Tag\CrudTag;
use App\Mail\Tag\NewInvoiceTag;
use App\Notifications\BaseNotification;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;

class InvoiceGenerateNotification extends BaseNotification implements ShouldQueue
{
    use Queueable;

    public function __construct($templates, $via, $invoice)
    {
        $this->templates = $templates;
        $this->via = $via;
        $this->model = $invoice;
        $this->auth = auth()->user();
        $this->tag = NewInvoiceTag::class;
        parent::__construct();
    }

    public function parseNotification()
    {

        $this->databaseNotificationUrl = route('invoice.details',$this->model->id);


        $this->databaseNotificationContent = $this->template()->database()->parse([
            '{invoice_number}' => $this->model->invoice_number
        ]);
    }
}