<?php

namespace App\Http\Controllers\Billar\Reports;

use App\Exports\Billar\ClientStatementExport;
use App\Filters\Billar\Reports\ClientStatementReportFilter;
use App\Http\Controllers\Controller;
use App\Services\Billar\Reports\ClientStatementReportService;
use Illuminate\Http\Request;
use Maatwebsite\Excel\Facades\Excel;

class ClientStatementReportController extends Controller
{
    public function __construct(ClientStatementReportService $service, ClientStatementReportFilter $filter)
    {
        $this->service = $service;
        $this->filter = $filter;
    }

    public function index()
    {
        return $this->service
            ->with('client:id,first_name,last_name', 'status:id,name,class')
            ->filters($this->filter)
            ->paginate(request('per_page', 10));
    }

    public function export()
    {
        return Excel::download(new ClientStatementExport(), 'client_statement_report.csv',\Maatwebsite\Excel\Excel::CSV);
    }
}
