<?php

namespace App\Http\Controllers\Billar\PaymentHistory;

use App\Http\Controllers\Controller;
use App\Services\Billar\PaymentHistory\InvoicePaymentService;
use Illuminate\Http\Request;

class InvoicePaymentController extends Controller
{
    public function __construct(InvoicePaymentService $service)
    {
        $this->service = $service;
    }

    public function checkout()
    {
        $paymentType = request('payment_type');

        if ($paymentType == 'stripe') {
            try {
                $this->service->stripePayment();
                return created_responses('payment');

            } catch (\Exception $exception) {
                return [
                    'status' => 500,
                    'error' => $exception->getMessage()
                ];
            }

        } elseif ($paymentType == 'paypal') {
            try {
                $this->service->paypalPayment();
                return created_responses('payment');
            } catch (\Exception $exception) {
                return [
                    'status' => 500,
                    'error' => $exception->getMessage()
                ];
            }
        } elseif ($paymentType == 'razorpay') {
            try {
                $this->service->razorpayPayment();
                return created_responses('payment');
            } catch (\Exception $exception) {
                return [
                    'status' => 500,
                    'error' => $exception->getMessage()
                ];
            }

        }elseif ($paymentType == 'paystack') {

            try {
                $secretKey = config()->get('services.paystack.paystack_secret');
                $ch = curl_init();
                curl_setopt($ch, CURLOPT_URL, "https://api.paystack.co/transaction/verify/".request('reference'));
                curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
                curl_setopt($ch, CURLOPT_HTTPHEADER, array(
                    "Authorization: Bearer $secretKey"
                ));
                $response = curl_exec($ch);
                curl_close($ch);

                $payment_data = json_decode($response, true);

                // Check the payment status
                if ($payment_data['data']['status'] === 'success') {
                    $this->service->paystackPayment();
                    return created_responses('payment');
                } else {
                    return [
                        'status' => false,
                        'error' => 'Payment failed'
                    ];
                }

            } catch (\Exception $exception) {
                return [
                    'status' => 500,
                    'error' => $exception->getMessage()
                ];
            }
        }
    }
}
