<?php

namespace App\Helpers\App\Traits;


use App\Services\App\SmsSetting\NexmoService;
use App\Services\App\SmsSetting\TwilioService;
use Illuminate\Support\Facades\Log;

trait SmsHelper
{

    public function sendSms($phone, $message = 'text')
    {
        $data = resolve(TwilioService::class)->getData();

        if ($data['sms_driver'] == 'twilio') {
            try {
                $sid = $data['account_sid'];
                $token = $data['auth_token'];
                $client = new \Twilio\Rest\Client($sid, $token);

                $client->messages->create(
                    $phone,
                    [
                        'from' => $data['twilio_number'],
                        'body' => $message
                    ]
                );
                return true;
            } catch (\Exception $exception) {
                Log::info($exception->getMessage());
                return true;
            }

        } elseif ($data['sms_driver'] == 'vonage') {
            try {
                $basic = new \Nexmo\Client\Credentials\Basic($data['key'], $data['secret_key']);
                $client = new \Nexmo\Client($basic);

                $client->message()->send([
                    'to' => preg_replace('/(\W*)/', '', $phone),
                    'from' => $data['vonage_number'],
                    'text' => $message
                ]);
                return true;

            } catch (\Exception $exception) {
                Log::info($exception->getMessage());
                return true;
            }

        }
    }

}