<?php

namespace App\Exports\Billar;

use App\Models\Billar\Client\Client;
use App\Models\Billar\Expense\Expense;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;

class ClientExport implements FromCollection, WithHeadings
{
    public function headings(): array
    {
        return [
            __t('name'),
            __t('email'),
            __t('phone_number'),
            __t('client_number'),
            __t('vat_number'),
            __t('address'),
            __t('country'),
        ];
    }

    public function collection()
    {
        $clients = Client::query()->with('user.profile')->get();

        return $clients->map(function ($row) {
            return [
                'name' => $row->user->full_name,
                'email' => $row->user->email,
                'phone_number' => @$row->user->profile->contact,
                'client_number' => $row->client_number,
                'vat_number' => @$row->user->profile->vat_number,
                'address' => @$row->user->profile->address,
                'country' => @$row->country->name,

            ];
        });
    }
}
